
function updateStreamRtmpValue() {
    $("#rtmpUrlTextInput").val(cameraSettings.RtmpServerUrl1);
    if (cameraSettings.RtmpStreamKey1Used == "1") {
        $("#streamKeyInput").val("xxxxxxxxxx");
    } else {
        $("#streamKeyInput").val("");
    }
    $("#authenRtmpCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.AuthenRtmp))
    $("#authenRtmpUserNameTextInput").val(cameraSettings.AuthenRtmpUserName);
    if (cameraSettings.AuthenRtmpPasswordUsed == "1") {
        $("#authenRtmpPasswordInput").val("xxxxxxxxxx");
    } else {
        $("#authenRtmpPasswordInput").val("");
    }
    $("#videoEncoderTypeSpan").text(cameraSettings.RtmpVideoInfo);
    $("#audioEncoderTypeSpan").text(cameraSettings.RtmpAudioInfo);
    $("#resolutionFormatSpan").text(cameraSettings.RtmpVideoResolution);
    $("#chunkSizeSpan").text(cameraSettings.RtmpChunkSize);
    $("#rtmpServerStatusSpan").text(cameraSettings.RtmpStatus);
    updateRTMPAuth();
    if (cameraSettings.RtmpEnable == "on") {
        AutoUpdateRTMPStatus();
    }
}

const imagesize2WebMap = new Map([
    ["3840,2160", "4K"],
    ["1920,1080", "1080P"],
    ["1280,720", "720P"]
]);

function updateStream1Select() {
    $("#resolution1Select option").remove();
    $("#resolution1Select").append($("<option></option>").val(cameraSettings.ImageSize1).text(imagesize2WebMap.get(cameraSettings.ImageSize1)));

    $("#frameRate1Select option").remove();
    $("#frameRate1Select").append($("<option></option>").val(cameraSettings.FrameRate1).text(cameraSettings.FrameRate1));

    $("#ipRatio1Select option").remove();
    switch (cameraSettings.FrameRate1) {
        case "60":
        case "59.94":
            $("#ipRatio1Select").append($("<option></option>").val("60").text("60"));
            $("#ipRatio1Select").append($("<option></option>").val("30").text("30"));
            $("#ipRatio1Select").append($("<option></option>").val("15").text("15"));
            $("#ipRatio1Select").append($("<option></option>").val("10").text("10"));
            break;
        case "50":
            $("#ipRatio1Select").append($("<option></option>").val("50").text("50"));
            $("#ipRatio1Select").append($("<option></option>").val("25").text("25"));
            break;
        case "30":
        case "29.97":
            $("#ipRatio1Select").append($("<option></option>").val("30").text("30"));
            $("#ipRatio1Select").append($("<option></option>").val("15").text("15"));
            $("#ipRatio1Select").append($("<option></option>").val("10").text("10"));
            break;
        case "25":
            $("#ipRatio1Select").append($("<option></option>").val("25").text("25"));
            break;
        default:
    }
}

function updateStream2IpRatioSelect() {
    $("#ipRatio2Select option").remove();
    switch ($("#frameRate2Select").val()) {
        case "60":
        case "59.94":
            $("#ipRatio2Select").append($("<option></option>").val("60").text("60"));
            $("#ipRatio2Select").append($("<option></option>").val("30").text("30"));
            $("#ipRatio2Select").append($("<option></option>").val("15").text("15"));
            $("#ipRatio2Select").append($("<option></option>").val("10").text("10"));
            break;
        case "50":
            $("#ipRatio2Select").append($("<option></option>").val("50").text("50"));
            $("#ipRatio2Select").append($("<option></option>").val("25").text("25"));
            break;
        case "30":
        case "29.97":
            $("#ipRatio2Select").append($("<option></option>").val("30").text("30"));
            $("#ipRatio2Select").append($("<option></option>").val("15").text("15"));
            $("#ipRatio2Select").append($("<option></option>").val("10").text("10"));
            break;
        case "25":
            $("#ipRatio2Select").append($("<option></option>").val("25").text("25"));
            $("#ipRatio2Select").append($("<option></option>").val("13").text("13"));
            $("#ipRatio2Select").append($("<option></option>").val("12").text("12"));
            break;
        default:
    }
}

function updateStream2Select() {
    $("#resolution2Select option").remove();
    if (cameraSettings.OutputSource == "stream") {
        $("#resolution2Select").append($("<option></option>").val("640,360").text("640x360"));
        $("#resolution2Select").prop("disabled", "disabled");
    } else {
        switch (cameraSettings.Resolution) {
            case "2160p_60":
            case "2160p_5994":
            case "2160p_50":
            case "2160p_30":
            case "2160p_2997":
            case "2160p_25":
            case "1080p_60":
            case "1080p_5994":
            case "1080p_50":
            case "1080p_30":
            case "1080p_2997":
            case "1080p_25":
                $("#resolution2Select").append($("<option></option>").val("1920,1080").text("1080P"));
                $("#resolution2Select").append($("<option></option>").val("1280,720").text("720P"));
                break;
            case "720p_60":
            case "720p_5994":
            case "720p_50":
            case "720p_30":
            case "720p_2997":
            case "720p_25":
                $("#resolution2Select").append($("<option></option>").val("1280,720").text("720P"));
                break;
            case "1080i_60":
            case "1080i_5994":
            case "1080i_50":
                $("#resolution2Select").append($("<option></option>").val("1920,1080").text("1080i"));
                break;
            default:
        }
    }
    $("#frameRate2Select option").remove();
    switch (cameraSettings.Resolution) {
        case "2160p_60":
        case "1080p_60":
        case "720p_60":
            $("#frameRate2Select").append($("<option></option>").val("60").text("60"));
            $("#frameRate2Select").append($("<option></option>").val("30").text("30"));
            break;
        case "2160p_5994":
        case "1080p_5994":
        case "720p_5994":
            $("#frameRate2Select").append($("<option></option>").val("59.94").text("59.94"));
            $("#frameRate2Select").append($("<option></option>").val("29.97").text("29.97"));
            break;
        case "2160p_50":
        case "1080p_50":
        case "720p_50":
            $("#frameRate2Select").append($("<option></option>").val("50").text("50"));
            $("#frameRate2Select").append($("<option></option>").val("25").text("25"));
            break;
        case "2160p_30":
        case "1080p_30":
        case "720p_30":
            $("#frameRate2Select").append($("<option></option>").val("30").text("30"));
            break;
        case "2160p_2997":
        case "1080p_2997":
        case "720p_2997":
            $("#frameRate2Select").append($("<option></option>").val("29.97").text("29.97"));
            break;
        case "2160p_25":
        case "1080p_25":
        case "720p_25":
            $("#frameRate2Select").append($("<option></option>").val("25").text("25"));
            break;
        case "1080i_60":
            $("#frameRate2Select").append($("<option></option>").val("60").text("60"));
            break;
        case "1080i_5994":
            $("#frameRate2Select").append($("<option></option>").val("59.94").text("59.94"));
            break;
        case "1080i_50":
            $("#frameRate2Select").append($("<option></option>").val("50").text("50"));
            break;
        default:
    }
}

function updateStream3Select() {
    $("#resolution3Select option").remove();
    $("#resolution3Select").append($("<option></option>").val("640,360").text("640x360"));

    $("#frameRate3Select option").remove();
    $("#frameRate3Select").append($("<option></option>").val(cameraSettings.FrameRate3).text(cameraSettings.FrameRate3));

    $("#ipRatio3Select option").remove();
    switch (cameraSettings.FrameRate3) {
        case "30":
        case "29.97":
            $("#ipRatio3Select").append($("<option></option>").val("30").text("30"));
            $("#ipRatio3Select").append($("<option></option>").val("15").text("15"));
            $("#ipRatio3Select").append($("<option></option>").val("10").text("10"));
            break;
        case "25":
            $("#ipRatio3Select").append($("<option></option>").val("25").text("25"));
            $("#ipRatio3Select").append($("<option></option>").val("13").text("13"));
            $("#ipRatio3Select").append($("<option></option>").val("12").text("12"));
            break;
        default:
    }
}

function checkInterlaceStream2() {
    if (cameraSettings.Resolution.indexOf("1080i") >= 0) {
        document.getElementById("resolution2Select").disabled = true;
        document.getElementById("frameRate2Select").disabled = true;
        document.getElementById("ipRatio2Select").disabled = true;
    } else if (cameraSettings.OutputSource == "stream") {
        document.getElementById("resolution2Select").disabled = true;
        document.getElementById("frameRate2Select").disabled = false;
        document.getElementById("ipRatio2Select").disabled = false;
    } else {
        document.getElementById("resolution2Select").disabled = false;
        document.getElementById("frameRate2Select").disabled = false;
        document.getElementById("ipRatio2Select").disabled = false;
    }
}

function updateStreamRtspValue() {
    $("#authenRtspCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.AuthenRTSP))
    $("#multicastCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.Multicast))
    updateStream1Select();
    $("#resolution1Select").val(cameraSettings.ImageSize1);
    $("#frameRate1Select").val(cameraSettings.FrameRate1);
    $("#bitRate1TextInput").val(cameraSettings.BitRate1);
    $("#rateControl1Select").val(cameraSettings.CBR1);
    $("#ipRatio1Select").val(cameraSettings.IFrameRatio1);
    updateStream2Select();
    $("#resolution2Select").val(cameraSettings.ImageSize2);
    $("#frameRate2Select").val(cameraSettings.FrameRate2);
    $("#bitRate2TextInput").val(cameraSettings.BitRate2);
    $("#rateControl2Select").val(cameraSettings.CBR2);
    updateStream2IpRatioSelect();
    $("#ipRatio2Select").val(cameraSettings.IFrameRatio2);
    updateStream3Select();
    $("#resolution3Select").val(cameraSettings.ImageSize3);
    $("#frameRate3Select").val(cameraSettings.FrameRate3);
    $("#bitRate3TextInput").val(cameraSettings.BitRate3);
    $("#rateControl3Select").val(cameraSettings.CBR3);
    $("#ipRatio3Select").val(cameraSettings.IFrameRatio3);
}

function updateStreamMpeg2tsValue() {
    $("#mpeg2tsIpTextInput").val(cameraSettings.MPEG2TSIP);
    $("#mpeg2tsPortTextInput").val(cameraSettings.MPEG2TSPort);
}

function updateStreamSrtValue() {
    $("#connectionModeSelect").val(cameraSettings.SRTConnectMode);
    $("#srtUrlTextInput").val(cameraSettings.SRTUrl);
    $("#srtPortTextInput").val(cameraSettings.SRTPort);
    $("#streamIdTextInput").val(cameraSettings.SRTStreamID);
    $("#latencyTextInput").val(cameraSettings.SRTLatency);
    $("#encryptionSelect").val(cameraSettings.SRTEncryption);
    if (cameraSettings.SRTPassphraseUsed == "1") {
        $("#passphraseInput").val("xxxxxxxxxx");
    } else {
        $("#passphraseInput").val("");
    }
    if (cameraSettings.SRTEnable == "on") {
        $("#srtStatusSpan").text("SRT Enable");
    } else {
        $("#srtStatusSpan").text("SRT Disable");
    }
    updateSRTConnectMode();
    updateSrtEncryption();
}

function showRTMP() {
    document.getElementById("Div_Rtmp").style.display = "block";
    document.getElementById("Div_Rtsp").style.display = "none";
    document.getElementById("Div_Mpegts").style.display = "none";
    document.getElementById("Div_Srt").style.display = "none";
    document.getElementById("Div_Stream1").style.display = "none";
    document.getElementById("Div_Stream2").style.display = "block";
    document.getElementById("Div_Stream3").style.display = "none";
    document.getElementById("streamSource2Radio").style.display = "block";
    document.getElementById("stream2EnableCheckboxInput").style.display = "none";
    $("#streamSource2Radio").prop("checked", true);
    document.getElementById("bitRate2TextInput").disabled = false;
    document.getElementById("rateControl2Select").disabled = false;
    checkInterlaceStream2();
}

function showRTSP() {
    document.getElementById("Div_Rtmp").style.display = "none";
    document.getElementById("Div_Rtsp").style.display = "block";
    document.getElementById("Div_Mpegts").style.display = "none";
    document.getElementById("Div_Srt").style.display = "none";
    document.getElementById("Div_Stream1").style.display = "block";
    document.getElementById("Div_Stream2").style.display = "block";
    document.getElementById("Div_Stream3").style.display = "block";
    document.getElementById("streamSource1Radio").style.display = "none";
    document.getElementById("streamSource2Radio").style.display = "none";
    document.getElementById("stream1EnableCheckboxInput").style.display = "block";
    document.getElementById("stream2EnableCheckboxInput").style.display = "block";
}

function showMPEG2TS() {
    document.getElementById("Div_Rtmp").style.display = "none";
    document.getElementById("Div_Rtsp").style.display = "none";
    document.getElementById("Div_Mpegts").style.display = "block";
    document.getElementById("Div_Srt").style.display = "none";
    document.getElementById("Div_Stream1").style.display = "block";
    document.getElementById("Div_Stream2").style.display = "block";
    document.getElementById("Div_Stream3").style.display = "none";
    document.getElementById("streamSource1Radio").style.display = "block";
    document.getElementById("streamSource2Radio").style.display = "block";
    document.getElementById("stream1EnableCheckboxInput").style.display = "none";
    document.getElementById("stream2EnableCheckboxInput").style.display = "none";
}

function showSRT() {
    document.getElementById("Div_Rtmp").style.display = "none";
    document.getElementById("Div_Rtsp").style.display = "none";
    document.getElementById("Div_Mpegts").style.display = "none";
    document.getElementById("Div_Srt").style.display = "block";
    document.getElementById("Div_Stream1").style.display = "block";
    document.getElementById("Div_Stream2").style.display = "block";
    document.getElementById("Div_Stream3").style.display = "none";
    document.getElementById("streamSource1Radio").style.display = "block";
    document.getElementById("streamSource2Radio").style.display = "block";
    document.getElementById("stream1EnableCheckboxInput").style.display = "none";
    document.getElementById("stream2EnableCheckboxInput").style.display = "none";
}

function updateStreamPageCommonSelect() {
    $("#connectionModeSelect").append($("<option></option>").val("caller").text("Caller"));
    $("#connectionModeSelect").append($("<option></option>").val("listener").text("Listener"));
    $("#encryptionSelect").append($("<option></option>").val("none").text("None"));
    $("#encryptionSelect").append($("<option></option>").val("aes-128").text("AES-128"));
    $("#encryptionSelect").append($("<option></option>").val("aes-256").text("AES-256"));
    $("#rateControl1Select").append($("<option></option>").val("on").text("CBR"));
    $("#rateControl1Select").append($("<option></option>").val("off").text("VBR"));
    $("#rateControl2Select").append($("<option></option>").val("on").text("CBR"));
    $("#rateControl2Select").append($("<option></option>").val("off").text("VBR"));
    $("#rateControl3Select").append($("<option></option>").val("on").text("CBR"));
    $("#rateControl3Select").append($("<option></option>").val("off").text("VBR"));
}

function saveNdiSettings() {
    var cgiParam = {};
    addTime = 0;
    urlToSend = "/command/ndi.cgi?";

    cgiParam.NdiGroupName = $("#groupNameTextInput").val();
    cgiParam.NdiEnable = $("#ndihxEnableSelect").val();
    cgiParam.NdiMulticast = ($("#ndiMulticastCheckboxInput").is(':checked') == true) ? "on" : "off";
    cgiParam.NdiMulticastIp = $("#ndiMulticastIpTextInput").val();
    cgiParam.NdiMulticastNetmask = $("#ndiMulticastNetmaskTextInput").val();
    AddParameter("NdiGroupName", cgiParam.NdiGroupName);
    AddParameter("NdiEnable", cgiParam.NdiEnable);
    AddParameter("NdiMulticast", cgiParam.NdiMulticast);
    if (cgiParam.NdiMulticast == "on") {
        AddParameter("NdiMulticastIp", cgiParam.NdiMulticastIp);
        AddParameter("NdiMulticastNetmask", cgiParam.NdiMulticastNetmask);
    }

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send NDI Setting Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            console.log("NDI settings saved to " + cameraSettings.CameraName);
            reloadNdi();
            UnblockUIforPage();
        }
    });
}

/* ----------------------------------------------------START---------------------------------------------------- */
var gDeviceIndex   = 0;//current focus tab index
var gTableRowIndex = 0;
var gCameraConnCnt = 0;
var gPTZTimerId = 0;

function onCameraMappingApply(e){

    var obj1 = {};
    var obj2 = {};
    var obj3 = [];
    var obj4 = [];
    var obj5 = [];
    var obj6 = [];
    var Range = {};
    var currentSoundType = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;
    var arrayIndex = 0;

    obj1.Command = "SetSoundCamMap";
    obj1.SoundTabIndex = gDeviceIndex;
    obj1.SoundCamMap = {};

    obj2.PresetLinkMap = {};
    obj4.MapArray      = [];

    obj2.AzimuthRange = {};
    obj5.RangeArray      = [];

    if(currentSoundType == "0" || currentSoundType == "1"){//Shure:MXA910:0 Shure:MXA920:1

        for(arrayIndex = 0; arrayIndex<8; arrayIndex++){

                var mapping = {};
                mapping.PosIndex = arrayIndex;
                mapping.Camera   = document.getElementById("cameraMappingSeleceItem_div1_"+arrayIndex).value;
                mapping.Preset   = parseInt(document.getElementById("cameraMappingPreset_div1_"+arrayIndex).value,10);
                obj3.push(mapping);
        }

        Object.assign(obj4.MapArray, obj3);
        Object.assign(obj2.PresetLinkMap, obj4);
        Object.assign(obj1.SoundCamMap, obj2);

    }else if(currentSoundType == "2"){//Shure:MXA310:2

        for(arrayIndex = 0; arrayIndex<4; arrayIndex++){

            var mapping = {};
            mapping.PosIndex = arrayIndex;
            mapping.Camera   = document.getElementById("cameraMappingSeleceItem_div2_"+arrayIndex).value;
            mapping.Preset   = parseInt(document.getElementById("cameraMappingPreset_div2_"+arrayIndex).value,10);
            obj3.push(mapping);
        }

        Object.assign(obj4.MapArray, obj3);
        Object.assign(obj2.PresetLinkMap, obj4);
        Object.assign(obj1.SoundCamMap, obj2);

    }else if(currentSoundType == "3" || currentSoundType == "4"){//Sennheiser:TCC2:3,Sennheiser:TCCM:4

        for(arrayIndex = 0; arrayIndex<8; arrayIndex++){

                var mapping = {};
                mapping.PosIndex = arrayIndex;
                mapping.Camera   = document.getElementById("cameraMappingSeleceItem_div3_"+arrayIndex).value;
                mapping.Preset   = parseInt(document.getElementById("cameraMappingPreset_div3_"+arrayIndex).value,10);
                obj3.push(mapping);

                var Range = {};
                Range.RangeIndex = arrayIndex;
                Range.From = parseInt(document.getElementById("cameraMappingAzimuthFrom_div3_"+arrayIndex).value,10);
                Range.To   = parseInt(document.getElementById("cameraMappingAzimuthTo_div3_"+arrayIndex).value,10);;
                obj6.push(Range);
        }

        Object.assign(obj4.MapArray,      obj3);
        Object.assign(obj5.RangeArray,    obj6)
        Object.assign(obj2.PresetLinkMap, obj4);
        Object.assign(obj2.AzimuthRange,  obj5);
        Object.assign(obj1.SoundCamMap,   obj2);

    }else if(currentSoundType == "5" || currentSoundType == "6" || currentSoundType == "7"){
        //Nureva:HDL300:5,Nureva:HDL310:6,Nureva:HDL410:7

        for(arrayIndex = 0; arrayIndex<8; arrayIndex++){

            var mapping = {};
            mapping.PosIndex = arrayIndex;
            mapping.Camera   = document.getElementById("cameraMappingSeleceItem_div4_"+arrayIndex).value;
            mapping.Preset   = parseInt(document.getElementById("cameraMappingPreset_div4_"+arrayIndex).value,10);
            obj3.push(mapping);

            var Range = {};
            Range.RangeIndex = arrayIndex;
            Range.From = parseInt(document.getElementById("cameraMappingAzimuthFrom_div4_"+arrayIndex).value,10);
            Range.To   = parseInt(document.getElementById("cameraMappingAzimuthTo_div4_"+arrayIndex).value,10);;
            obj6.push(Range);
        }

        Object.assign(obj4.MapArray,      obj3);
        Object.assign(obj5.RangeArray,    obj6)
        Object.assign(obj2.PresetLinkMap, obj4);
        Object.assign(obj2.AzimuthRange,  obj5);
        Object.assign(obj1.SoundCamMap,   obj2);


    }else if(currentSoundType == "8"){//Yamaha:RM-CG:8

        for(arrayIndex = 0; arrayIndex<8; arrayIndex++){

            var mapping = {};
            mapping.PosIndex = arrayIndex;
            mapping.Camera   = document.getElementById("cameraMappingSeleceItem_div5_"+arrayIndex).value;
            mapping.Preset   = parseInt(document.getElementById("cameraMappingPreset_div5_"+arrayIndex).value,10);
            obj3.push(mapping);

            var Range = {};
            Range.RangeIndex = arrayIndex;
            Range.From = parseInt(document.getElementById("cameraMappingAzimuthFrom_div5_"+arrayIndex).value,10);
            Range.To   = parseInt(document.getElementById("cameraMappingAzimuthTo_div5_"+arrayIndex).value,10);;
            obj6.push(Range);
        }

        Object.assign(obj4.MapArray,      obj3);
        Object.assign(obj5.RangeArray,    obj6)
        Object.assign(obj2.PresetLinkMap, obj4);
        Object.assign(obj2.AzimuthRange,  obj5);
        Object.assign(obj1.SoundCamMap,   obj2);

    }

    console.log( "obj1 :",obj1);
    sendMessage("SetSoundCamMap",obj1);
    e.disabled = true;
}

function changeConnectStatus(e){
    //SwitchingMode turn on ----> layout setting hide
    if(e.checked){

        if(document.getElementById("DeviceIPInput_"+gDeviceIndex).value != "")
            sendMessage("SoundConnect",gDeviceIndex);
        else
            e.checked = false;
    }
    else{
        sendMessage("SoundDisconnect",gDeviceIndex);
        document.getElementById("deviceTypeSel_"+gDeviceIndex).disabled = false;
        document.getElementById("DeviceIPInput_"+gDeviceIndex).disabled = false;
        document.getElementById("PasswordInput_"+gDeviceIndex).disabled = false;
        document.getElementById("advancedButton_"+gDeviceIndex).disabled = false;
    }
}

/* AI setting */
function onAISettingModelApplyClick(){

    var jsonmsg = {};

    jsonmsg.Command = "SetCamAISetting";
    jsonmsg.IPAddress = document.getElementById("AISettingModelIPAddress").value;

    if(document.getElementById("AISettingModelInput").checked == true)
        jsonmsg.IsAI_PeopleTrackingEnable = true;
    else
        jsonmsg.IsAI_PeopleTrackingEnable = false;

    jsonmsg.AI_PeopleTrackingMode = parseInt(document.getElementById("SelectAISettingModelPeopleTracking").value,10);

    sendMessage("SetCamAISetting",jsonmsg);

    $('#AISettingModal').modal('hide');

    document.getElementById("BtnAISettingModalApply").disabled = true;
}

function FPSOnChange(){

    var FPS = parseInt(document.getElementById("selectFPS").value,10);

    sendMessage("SetVideoFps",FPS);
}

function ResolutionOnChange(){

    var resolution = document.getElementById("selectResolution").value;

    sendMessage("SetVideoResolution",resolution);
}

function InputAISettingModelPeopleTrackingOnChange(){

    document.getElementById("BtnAISettingModalApply").disabled = false;

}

function SelectAISettingModelPeopleTrackingOnChange(){

    document.getElementById("BtnAISettingModalApply").disabled = false;

}

function InputModelHomePositionOnChange(){

    var curNumber = document.getElementById("InputModelHomePosition").value;

    document.getElementById("BtnModelApply").disabled = false;

    if(curNumber < 0 )
        document.getElementById("InputModelHomePosition").value = 0;

    if(curNumber > 256)
        document.getElementById("InputModelHomePosition").value = 255;
}

function SelectModelPresetOnChange(){

    document.getElementById("BtnModelApply").disabled = false;

    if(document.getElementById("SelectModelHomePosition").value == 0){
        document.getElementById("InputModelHomePosition").disabled = true;
    }else{
        document.getElementById("InputModelHomePosition").disabled = false;
    }
}

function SelectModelApplyStatusChange(){

    document.getElementById("BtnModelApply").disabled = false;
}

function onModelApplyClick(){

    var msgSend = {};
    var obj1 = {};
    var obj2 = {};
    var deviceType = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;

    obj1.Command = "SetSoundAdvanceSetting";
    obj1.SoundTabIndex = gDeviceIndex;
    obj1.SoundAdvanceSetting = {};


    if( deviceType == "3" || deviceType == "4" || deviceType == "5" || deviceType == "6"  || deviceType == "7")
        obj2.AudioTriggerLevel = parseInt(document.getElementById("InputModelAudioTrigger").value,10);

    obj2.TimeToTriggerPreset   = parseInt(document.getElementById("SelectModelPreset").value,10);
    obj2.BackToHomeTime = parseInt(document.getElementById("SelectModelHomeTimes").value,10);
    obj2.BackToHomeSwitchCamera = document.getElementById("SelectModelHomeCamera").value;
    obj2.BackToHomePos  = parseInt(document.getElementById("SelectModelHomePosition").value,10);
    obj2.BackToHomePreset = parseInt(document.getElementById("InputModelHomePosition").value,10);

    Object.assign(obj1.SoundAdvanceSetting, obj2);

    sendMessage("SetSoundAdvanceSetting",obj1);
    $('#exampleModal').modal('hide');
    document.getElementById("BtnModelApply").disabled = true;

}
function onChangeCameraMappingApplyStatus(index){

    document.getElementById("cameraMapping_div"+index).disabled = false;
}

function onChangeSoundDeviceApplyStatus(){

    document.getElementById("deviceApply_"+gDeviceIndex).disabled = false;
}

function onChangeSoundDeviceSettingApply(){

    var msgSend = {};
    var obj1 = {};
    var obj2 = {};
    //var deviceType = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;

    obj1.Command = "SetSoundSetting";
    obj1.SoundTabIndex = gDeviceIndex;
    obj1.SoundSetting = {};

    obj2.SoundDeviceIndex   = parseInt(document.getElementById("deviceTypeSel_"+gDeviceIndex).value,10);
    obj2.IPAddress          = document.getElementById("DeviceIPInput_"+gDeviceIndex).value;
    obj2.Port               = parseInt(document.getElementById("DevicePortInput_"+gDeviceIndex).value,10);
    obj2.Password           = document.getElementById("PasswordInput_"+gDeviceIndex).value;

    Object.assign(obj1.SoundSetting, obj2);

    sendMessage("SetSoundSetting",obj1);
    sendMessage("GetSoundCamMap" ,gDeviceIndex);

    document.getElementById("deviceApply_"+gDeviceIndex).disabled = true;
}


/*syncDeviceCount*/
function syncDeviceCount() {

    var cnt = document.getElementById("deviceCntSel").value;

    /*Hide all tabs */
    for (x = 0; x < 24; x++) {
        $("#A_tabDevice_"+x).hide();
    }

    for (x = 0; x < cnt; x++) {
        $("#A_tabDevice_"+x).show();
    }

    sendMessage("SetSoundNumbers",parseInt(cnt,10));
}

function SettingModeChange(e){

    var SettingModeStatus;

    if(e.checked == true){
        document.getElementById("SettingModeCheckboxInput").checked = true;
        document.getElementById("Label_SettingModeWarning").innerHTML = 'Voice source active, in this mode it does not switch/change camera source and presets';
    }
    else{
        document.getElementById("SettingModeCheckboxInput").checked = false;
        document.getElementById("Label_SettingModeWarning").innerHTML = "";
    }

    SettingModeStatus = document.getElementById("SettingModeCheckboxInput").checked ;

    sendMessage("SetSettingMode",SettingModeStatus);
}

function updateCameraMappingTable(deviceType,msg) {

    if(deviceType == "Shure:MXA910" || deviceType == "Shure:MXA920")
    {
        document.getElementById("Div_cameraMapping_1").style.display = "block";
        document.getElementById("Div_cameraMapping_2").style.display = "none";
        document.getElementById("Div_cameraMapping_3").style.display = "none";
        document.getElementById("Div_cameraMapping_4").style.display = "none";
        document.getElementById("Div_cameraMapping_5").style.display = "none";
    }
    else if(deviceType == "Shure:MXA310" )
    {
        document.getElementById("Div_cameraMapping_1").style.display = "none";
        document.getElementById("Div_cameraMapping_2").style.display = "block";
        document.getElementById("Div_cameraMapping_3").style.display = "none";
        document.getElementById("Div_cameraMapping_4").style.display = "none";
        document.getElementById("Div_cameraMapping_5").style.display = "none";
    }
    else if(deviceType == "Sennheiser:TCC2" || deviceType == "Sennheiser:TCCM")
    {
        document.getElementById("Div_cameraMapping_1").style.display = "none";
        document.getElementById("Div_cameraMapping_2").style.display = "none";
        document.getElementById("Div_cameraMapping_3").style.display = "block";
        document.getElementById("Div_cameraMapping_4").style.display = "none";
        document.getElementById("Div_cameraMapping_5").style.display = "none";
    }
    else if(deviceType == "Nureva:HDL300" || deviceType == "Nureva:HDL310" || deviceType == "Nureva:HDL410")
    {
        document.getElementById("Div_cameraMapping_1").style.display = "none";
        document.getElementById("Div_cameraMapping_2").style.display = "none";
        document.getElementById("Div_cameraMapping_3").style.display = "none";
        document.getElementById("Div_cameraMapping_4").style.display = "block";
        document.getElementById("Div_cameraMapping_5").style.display = "none";
    } 
    else if(deviceType == "Yamaha:RM-CG" )
    {
        document.getElementById("Div_cameraMapping_1").style.display = "none";
        document.getElementById("Div_cameraMapping_2").style.display = "none";
        document.getElementById("Div_cameraMapping_3").style.display = "none";
        document.getElementById("Div_cameraMapping_4").style.display = "none";
        document.getElementById("Div_cameraMapping_5").style.display = "block";
    }
    else
    {
        document.getElementById("Div_cameraMapping_1").style.display = "none";
        document.getElementById("Div_cameraMapping_2").style.display = "none";
        document.getElementById("Div_cameraMapping_3").style.display = "none";
        document.getElementById("Div_cameraMapping_4").style.display = "none";
        document.getElementById("Div_cameraMapping_5").style.display = "none";
    }

}
function transferDeviceTypeToString(typeValue) {

    switch(typeValue){

        case "0":
            return "Shure:MXA910";
            break;
        case "1":
            return "Shure:MXA920";
            break;
        case "2":
            return "Shure:MXA310";
            break;
        case "3":
            return "Sennheiser:TCC2";
            break;
        case "4":
            return "Sennheiser:TCCM";
            break;
        case "5":
            return "Nureva:HDL300";
            break;
        case "6":
            return "Nureva:HDL310";
            break;
        case "7":
            return "Nureva:HDL410";
            break;
        case "8":
            return "Yamaha:RM-CG";
            break;
        default:
            return "Shure:MXA910";
    }

}

function updateDevicePortStatus(deviceTypeIndex){

    //device port enabled or disabled

    if(deviceTypeIndex == 0 || deviceTypeIndex == 1 || deviceTypeIndex == 2 || 
        deviceTypeIndex == 3 || deviceTypeIndex == 4 || deviceTypeIndex == 8){

        document.getElementById("DevicePortInput_"+ gDeviceIndex).disabled = true;

        //if(deviceTypeIndex == 0 || deviceTypeIndex == 1 ||deviceTypeIndex == 2)
            //$("#DevicePortInput_"+gDeviceIndex).val("2202");
        //else if(deviceTypeIndex == 3)
            //$("#DevicePortInput_"+gDeviceIndex).val("45");
        //else
            //$("#DevicePortInput_"+gDeviceIndex).val("49280");
    }else{
        document.getElementById("DevicePortInput_"+ gDeviceIndex).disabled = false;
    }

}

function syncDeviceType() {

    var jsonmsg = {};
    var value = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;
    
    if(value == "4"){
        $("#password_"+gDeviceIndex).show();
    }
    else{
        $("#password_"+gDeviceIndex).hide();
    }

    $("#A_tabDevice_"+gDeviceIndex).text(transferDeviceTypeToString(value));

    onChangeSoundDeviceApplyStatus();

    jsonmsg.Command = "GetSoundDevicePort";
    jsonmsg.SoundTabIndex = gDeviceIndex;
    jsonmsg.SoundDeviceIndex = parseInt(value,10);
    sendMessage("GetSoundDevicePort",jsonmsg);

    updateCameraMappingTable(transferDeviceTypeToString(value)); 

    GetSoundAdvanceInfo();
}



//var wsUri = "ws://"+location.hostname+":9015";
//var websocket = null;

function initWebSocket() {

    if (websocket && websocket.readyState == 1) {
        console.log('Already connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageVideo("GetVideoOutputSetting");
        sendMessageIndex("GetCurrentProfileID");
        sendMessage("GetSoundNumbers");//get Sound number
        sendMessage("GetSettingMode"); //get setting mode
        tabPageStream();
        onSearchCamera();
        sendMessage("GetVideoResolution");
        sendMessage("GetVideoFps");
    }
    else
    {
        if(gProtocolStr == "http:")
            websocket = new WebSocket( wsUri );
        else
            websocket = new WebSocket( wssUri );
    }

    websocket.addEventListener('open', function() {
        console.log('open connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageVideo("GetVideoOutputSetting");
        sendMessageIndex("GetCurrentProfileID");
        sendMessage("GetSoundNumbers");//get Sound number
        sendMessage("GetSettingMode"); //get setting mode
        tabPageStream();
        onSearchCamera();
        sendMessage("GetVideoResolution");
        sendMessage("GetVideoFps");

    });

    websocket.addEventListener('error',function(evt){
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    });

    websocket.addEventListener('message',function(evt){
        //console.log('Message received',evt.data);
        if(evt.data instanceof Blob)
        {

        }
        else
        {
            //console.log('Message received');
            receivedData(evt.data);
        }
    });

    websocket.onclose = function(evt) 
    {
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    };


}

function receivedData(data) {

    var tempData = data;
    var obj = JSON.parse(tempData);

    console.log('obj.Reply:',obj.Reply);

    switch (obj.Reply) {

        case "SearchCamera": //reply search camera result
            console.log('SearchCamera result!!');
            updatedSearchCameraTable(obj);
            break;

        case "GetSoundNumbers": //reply search camera result
            console.log('GetSoundNumbers result!!');
            updateSoundNumbers(obj);
        break;

        case "GetSoundSetting": //reply sound setting
            console.log('GetSoundSetting result!!');
            updateSoundSetting(obj);
        break;

        case "GetSoundAdvanceSetting": //reply sound advance setting
            console.log('GetSoundAdvanceSetting result!!');
            updateAdvanceSetting(obj);
        break;

        case "GetSoundCamMap": //reply sound camera mapping
            console.log('GetSoundCameraMapping!!');
            console.log('obj:',obj);
            updateCameraMapping(obj);
        break;

        case "SoundConnect":
            console.log('SoundConnect!!');
            updateSoundDeviceConnect(obj);
        break;

        case "GetCamAISetting":
            console.log('SoundConnect!!');
            updateCamAISetting(obj);
        break;

        case "CameraConnect":
            console.log('CameraConnect Reply!!');
            updateCamConnect(obj);
            UnblockUIforPage();
        break;

        case "GetVideoResolution":
            console.log('GetVideoResolution!!');
            updateVideoResolution(obj);
        break;

        case "GetVideoFps":
            console.log('GetVideoFps!!');
            updateVideoFps(obj);
        break;

        case "GetSoundPos":
            console.log('GetSoundPos!!');
            updateGetSoundPos(obj);
        break;

        case "GetSoundSourceData":
            console.log('GetSoundSourceData!!');
            updateGetSoundSourceData(obj);
        break;

        case "GetSettingMode":
            console.log('GetSettingMode!!');
            updateGetSettingMode(obj);
        break;

        case "GetSoundDevicePort":
            console.log('caseGetSoundDevicePort!!');
            updateSoundDevicePort(obj);
        break;

        case "GetVideoOutputSetting": //reply Video Output Setting result
            updatedVideoOutputStatus(obj);
        break;

        case "GetFocusMode":
            updatedPTZFocusMode(obj);
        break;

        case "GetMirrorFlipType":
            updatedMirrorFlipType(obj);
        break;

        case "GetPanFlip":
            updatedPanFlip(obj);
        break;
    }

}

function updatedPTZFocusMode(msg) {

    console.log('Mode:', msg.Mode);

    if(msg.Mode == "Auto"){
        document.getElementById("focusModeCheckboxInput").checked = true;
    }
    else
        document.getElementById("focusModeCheckboxInput").checked = false;

}

function updatedMirrorFlipType(msg) {

    //console.log('Type:', msg.Type);

    document.getElementById("PTZMirrorFlipType").value = msg.Type;

}

function updatedPanFlip(msg) {

    console.log('IsFlip:', msg.IsFlip);

    document.getElementById("PTZLRDirection").checked = msg.IsFlip;
    

}

function updatedVideoOutputStatus(msg) {

    if(msg.IsStartStreaming == true){
        GotoVideoOutputSetting();
    }

}

function updateSoundDevicePort(msg) {

    $("#DevicePortInput_"+msg.SoundTabIndex).val(msg.Port);
    updateDevicePortStatus(msg.SoundDeviceIndex);

}

function updateGetSettingMode(msg) {

    if(msg.Status == true){
        document.getElementById("SettingModeCheckboxInput").checked = true;
        document.getElementById("Label_SettingModeWarning").innerHTML = 'Voice source active, in this mode it does not switch/change camera source and presets';

    }
    else{
        document.getElementById("SettingModeCheckboxInput").checked = false;
        document.getElementById("Label_SettingModeWarning").innerHTML = "";
    }
}

function updateGetSoundSourceData(msg) {

    console.log('updateGetSoundSourceData');

    var currentSoundType = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;
    
    if(msg.SoundTabIndex == gDeviceIndex ){

        if(currentSoundType == "0" || currentSoundType == "1"){//Shure:MXA910:0 Shure:MXA920:1

            document.getElementById("micInfo_div1").innerText = msg.SourceData;

        }else if(currentSoundType == "2"){//Shure:MXA310:2

            document.getElementById("micInfo_div2").innerText = msg.SourceData;

        }else if(currentSoundType == "3" || currentSoundType == "4"){//Sennheiser:TCC2:3,Sennheiser:TCCM:4

            document.getElementById("micInfo_div3").innerText = msg.SourceData;

        }else if(currentSoundType == "5" || currentSoundType == "6" || currentSoundType == "7"){
            //Nureva:HDL300:5,Nureva:HDL310:6,Nureva:HDL410:7
            document.getElementById("micInfo_div4").innerText = msg.SourceData;

        }else if(currentSoundType == "8"){//Yamaha:RM-CG:8

            document.getElementById("micInfo_div5").innerText = msg.SourceData;
        }

    }


}

function updateGetSoundPos(msg) {

    console.log('updateGetSoundPos');

    var currentSoundType = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;

    if(msg.SoundTabIndex == gDeviceIndex ){

        if(currentSoundType == "0" || currentSoundType == "1"){//Shure:MXA910:0 Shure:MXA920:1
            if(msg.IsOn == true)
                document.getElementById("Light_div1_"+msg.PosIndex).src= "./images/Selected.png";
            else
                document.getElementById("Light_div1_"+msg.PosIndex).src= "./images/Disable.png";

        }else if(currentSoundType == "2"){//Shure:MXA310:2
            if(msg.IsOn == true)
                document.getElementById("Light_div2_"+msg.PosIndex).src= "./images/Selected.png";
            else
                document.getElementById("Light_div2_"+msg.PosIndex).src= "./images/Disable.png";

        }else if(currentSoundType == "3" || currentSoundType == "4"){//Sennheiser:TCC2:3,Sennheiser:TCCM:4
            if(msg.IsOn == true)
                document.getElementById("Light_div3_"+msg.PosIndex).src= "./images/Selected.png";
            else
                document.getElementById("Light_div3_"+msg.PosIndex).src= "./images/Disable.png";

        }else if(currentSoundType == "5" || currentSoundType == "6" || currentSoundType == "7"){
            //Nureva:HDL300:5,Nureva:HDL310:6,Nureva:HDL410:7
            if(msg.IsOn == true)
                document.getElementById("Light_div4_"+msg.PosIndex).src= "./images/Selected.png";
            else
                document.getElementById("Light_div4_"+msg.PosIndex).src= "./images/Disable.png";

        }else if(currentSoundType == "8"){//Yamaha:RM-CG:8
            if(msg.IsOn == true)
                document.getElementById("Light_div5_"+msg.PosIndex).src= "./images/Selected.png";
            else
                document.getElementById("Light_div5_"+msg.PosIndex).src= "./images/Disable.png";
        }
    }
}

function updateVideoFps(msg) {

    console.log('updateVideoFps');
    $("#selectFPS").val(msg.VideoFps);
}

function updateVideoResolution(msg) {

    console.log('updateCamConnect');
    $("#selectResolution").val(msg.VideoResolution);
}

function updateCamConnect(msg) {

    console.log('msg.IPAddress:',msg.IPAddress);
    console.log('msg.Result:',msg.Result);

    var tableIndex = document.getElementById("tableSearchCamera").rows.length;
    var index = 0;


    for(index= 0 ; index < tableIndex; index++)
    {
        if(document.getElementById("cameraIP_"+index).innerText == msg.IPAddress)
        {
            break;
        }
    }

    if(msg.Result == "Success")
    {
        document.getElementById("cameraStatus_"+index).innerText = "Disonnect";
        document.getElementById("cameraStatus_"+index).style.backgroundColor = "#ffffff";//white
        gCameraConnCnt++;
        DisableResolutonAndFps(true);
        sendMessage("GetSoundCamMap" ,gDeviceIndex); //update Camera count
    }
    else
    {
        document.getElementById("cameraStatus_"+index).innerText = "Connect";
        document.getElementById("cameraStatus_"+index).style.backgroundColor = "#000000";//black
        alert( msg.Result);
    }
}

function updateCamAISetting(msg) {

    $('#AISettingModal').modal('show');
    //console.log('msg.IPAddress:',msg.IPAddress);
    //console.log('msg.IsAI_PeopleTrackingEnable:',msg.IsAI_PeopleTrackingEnable);
    //console.log('msg.AI_PeopleTrackingMode:',msg.AI_PeopleTrackingMode);

    document.getElementById("AISettingModelIPAddress").value = msg.IPAddress;

    if(msg.IsAI_PeopleTrackingEnable == true)
        document.getElementById("AISettingModelInput").checked = true;
    else
        document.getElementById("AISettingModelInput").checked = false;

    document.getElementById("SelectAISettingModelPeopleTracking").value = msg.AI_PeopleTrackingMode;
}

function updateSoundDeviceConnect(msg) {

    console.log('msg.SoundTabIndex:',msg.SoundTabIndex);
    console.log('msg.Result:',msg.Result);
    
    if(msg.Result == "Success"){
        document.getElementById("connectCheckboxInput_"+msg.SoundTabIndex).checked = true;
        document.getElementById("deviceTypeSel_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("DeviceIPInput_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("advancedButton_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("PasswordInput_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("deviceApply_"+msg.SoundTabIndex).disabled = true;
    }

    else
        document.getElementById("connectCheckboxInput_"+msg.SoundTabIndex).checked = false;
    
    
}

function ResetCameraMappingLightIcon(){

    var i =0;

    //Shure:MXA910:0 Shure:MXA920:1
    for(i=0;i<8;i++){
        document.getElementById("Light_div1_"+ i).src= "./images/Disable.png";
    }

    //Shure:MXA310:2
    for(i=0;i<4;i++){
        document.getElementById("Light_div2_"+i).src= "./images/Disable.png";
    }

    //Sennheiser:TCC2:3,Sennheiser:TCCM:4
    for(i=0;i<8;i++){
        document.getElementById("Light_div3_"+i).src= "./images/Disable.png";
    }

    //Nureva:HDL300:5,Nureva:HDL310:6,Nureva:HDL410:7
    for(i=0;i<8;i++){
        document.getElementById("Light_div4_"+i).src= "./images/Disable.png";
    }

    //Yamaha:RM-CG:8
    for(i=0;i<8;i++){
        document.getElementById("Light_div5_"+i).src= "./images/Disable.png";
    }
}

function updateCameraMapping(msg) {

    console.log('msg.SoundTabIndex:',msg.SoundTabIndex);
    //SoundCamMapPresetLinkMap.ArrayCamera1
    var currentSoundType = document.getElementById("deviceTypeSel_"+msg.SoundTabIndex).value;

    ResetCameraMappingLightIcon();

    if(currentSoundType == "0" || currentSoundType == "1"){//Shure:MXA910:0 Shure:MXA920:1
        for(var j=0;j<8;j++){

            //remove all option
            $("#cameraMappingSeleceItem_div1_"+j+" option").remove();

            //append option Off
            var optionOff = $("<option />");
            optionOff.val(-1).text("Off");
            $("#cameraMappingSeleceItem_div1_"+j).append(optionOff);


            for(var i=0;i<msg.SoundCamMap.CameraSelectItems.CameraItemArray.length;i++){

                var option = $("<option />");
                option.val(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera).text(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera);
                $("#cameraMappingSeleceItem_div1_"+j).append(option);
            }

            for(var mapIndex=0;mapIndex<msg.SoundCamMap.PresetLinkMap.MapArray.length;mapIndex++){
                    if(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].PosIndex == j){
                        break;
                    }
            }
            $("#cameraMappingSeleceItem_div1_"+j).val(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].Camera);
            $("#cameraMappingPreset_div1_"+j).val(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].Preset);
        }

    }else if(currentSoundType == "2"){//Shure:MXA310:2

        for(var j=0;j<4;j++){
            //remove all option
            $("#cameraMappingSeleceItem_div2_"+j+" option").remove();

            //append option Off
            var optionOff = $("<option />");
            optionOff.val(-1).text("Off");
            $("#cameraMappingSeleceItem_div2_"+j).append(optionOff);


            for(var i=0;i<msg.SoundCamMap.CameraSelectItems.CameraItemArray.length;i++){

                var option = $("<option />");
                option.val(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera).text(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera);
                $("#cameraMappingSeleceItem_div2_"+j).append(option);
            }

            for(var mapIndex=0;mapIndex<msg.SoundCamMap.PresetLinkMap.MapArray.length;mapIndex++){
                    if(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].PosIndex == j){
                        break;
                    }
            }
            $("#cameraMappingSeleceItem_div2_"+j).val(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].Camera);
            $("#cameraMappingPreset_div2_"+j).val(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].Preset);

        }
    }else if(currentSoundType == "3" || currentSoundType == "4"){//Sennheiser:TCC2:3,Sennheiser:TCCM:4
        for(var j=0;j<8;j++){

            //remove all option
            $("#cameraMappingSeleceItem_div3_"+j+" option").remove();

            //append option Off
            var optionOff = $("<option />");
            optionOff.val(-1).text("Off");
            $("#cameraMappingSeleceItem_div3_"+j).append(optionOff);

            for(var i=0;i<msg.SoundCamMap.CameraSelectItems.CameraItemArray.length;i++){

                var option = $("<option />");
                option.val(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera).text(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera);
                $("#cameraMappingSeleceItem_div3_"+j).append(option);
            }

            for(var mapIndex=0;mapIndex<msg.SoundCamMap.PresetLinkMap.MapArray.length;mapIndex++){
                    if(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].PosIndex == j){
                        break;
                    }
            }
            $("#cameraMappingSeleceItem_div3_"+j).val(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].Camera);
            $("#cameraMappingPreset_div3_"+j).val(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].Preset);
            
            //AzimuthRange
            $("#cameraMappingAzimuthFrom_div3_"+j).val(msg.SoundCamMap.AzimuthRange.RangeArray[j].From);
            $("#cameraMappingAzimuthTo_div3_"+j).val(msg.SoundCamMap.AzimuthRange.RangeArray[j].To);

        }
    }else if(currentSoundType == "5" || currentSoundType == "6" || currentSoundType == "7"){
        //Nureva:HDL300:5,Nureva:HDL310:6,Nureva:HDL410:7

        for(var j=0;j<8;j++){

            //remove all option
            $("#cameraMappingSeleceItem_div4_"+j+" option").remove();

            //append option Off
            var optionOff = $("<option />");
            optionOff.val(-1).text("Off");
            $("#cameraMappingSeleceItem_div4_"+j).append(optionOff);

            for(var i=0;i<msg.SoundCamMap.CameraSelectItems.CameraItemArray.length;i++){

                var option = $("<option />");
                option.val(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera).text(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera);
                $("#cameraMappingSeleceItem_div4_"+j).append(option);
            }

            for(var mapIndex=0;mapIndex<msg.SoundCamMap.PresetLinkMap.MapArray.length;mapIndex++){
                    if(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].PosIndex == j){
                        break;
                    }
            }
            $("#cameraMappingSeleceItem_div4_"+j).val(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].Camera);
            $("#cameraMappingPreset_div4_"+j).val(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].Preset);

            //AzimuthRange
            $("#cameraMappingAzimuthFrom_div4_"+j).val(msg.SoundCamMap.AzimuthRange.RangeArray[j].From);
            $("#cameraMappingAzimuthTo_div4_"+j).val(msg.SoundCamMap.AzimuthRange.RangeArray[j].To);
        }
    }else if(currentSoundType == "8"){//Yamaha:RM-CG:8

        for(var j=0;j<8;j++){

            //remove all option
            $("#cameraMappingSeleceItem_div5_"+j+" option").remove();

            //append option Off
            var optionOff = $("<option />");
            optionOff.val(-1).text("Off");
            $("#cameraMappingSeleceItem_div5_"+j).append(optionOff);

            for(var i=0;i<msg.SoundCamMap.CameraSelectItems.CameraItemArray.length;i++){

                var option = $("<option />");
                option.val(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera).text(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera);
                $("#cameraMappingSeleceItem_div5_"+j).append(option);
            }

            for(var mapIndex=0;mapIndex<msg.SoundCamMap.PresetLinkMap.MapArray.length;mapIndex++){
                    if(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].PosIndex == j){
                        break;
                    }
            }
            $("#cameraMappingSeleceItem_div5_"+j).val(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].Camera);
            $("#cameraMappingPreset_div5_"+j).val(msg.SoundCamMap.PresetLinkMap.MapArray[mapIndex].Preset);

            //AzimuthRange
            $("#cameraMappingAzimuthFrom_div5_"+j).val(msg.SoundCamMap.AzimuthRange.RangeArray[j].From);
            $("#cameraMappingAzimuthTo_div5_"+j).val(msg.SoundCamMap.AzimuthRange.RangeArray[j].To);
        }
    }

}

function updateSoundSetting(msg) {

    console.log('msg.SoundTabIndex:',msg.SoundTabIndex);  

    $("#DeviceIPInput_"+msg.SoundTabIndex).val(msg.SoundSetting.IPAddress);
    $("#deviceTypeSel_"+msg.SoundTabIndex).val(msg.SoundSetting.SoundDeviceIndex);
    $("#DevicePortInput_"+msg.SoundTabIndex).val(msg.SoundSetting.Port);
    $("#PasswordInput_"+msg.SoundTabIndex).val(msg.SoundSetting.Password);
    
    if(msg.SoundSetting.isConnect == true){
        document.getElementById("connectCheckboxInput_"+msg.SoundTabIndex).checked = true;
        document.getElementById("deviceTypeSel_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("DeviceIPInput_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("advancedButton_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("deviceApply_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("PasswordInput_"+msg.SoundTabIndex).disabled = true;
    }
    else{
        document.getElementById("connectCheckboxInput_"+msg.SoundTabIndex).checked = false;
        document.getElementById("deviceTypeSel_"+msg.SoundTabIndex).disabled = false;
        document.getElementById("DeviceIPInput_"+msg.SoundTabIndex).disabled = false;
        document.getElementById("advancedButton_"+msg.SoundTabIndex).disabled = false;
        document.getElementById("PasswordInput_"+msg.SoundTabIndex).disabled = false;

        //document.getElementById("deviceApply_"+msg.SoundTabIndex).disabled = false;
    } 

    var value = document.getElementById("deviceTypeSel_"+msg.SoundTabIndex).value; 
    $("#A_tabDevice_"+msg.SoundTabIndex).text(transferDeviceTypeToString(value));

    if(value == "4"){
        $("#password_"+gDeviceIndex).show();
    }
    else{
        $("#password_"+gDeviceIndex).hide();
    }
    updateDevicePortStatus(value);
    updateCameraMappingTable(transferDeviceTypeToString(value),msg); 

}

function updateAdvanceSetting(msg) {

    console.log('msg.SoundTabIndex:',msg.SoundTabIndex);
    var deviceType = document.getElementById("deviceTypeSel_"+msg.SoundTabIndex).value;
    
    if(deviceType=="3" || deviceType=="4" || deviceType=="5" || deviceType=="6" || deviceType=="7"){

        $("#audioLevel").show();
        $("#InputModelAudioTrigger").val(msg.SoundAdvanceSetting.AudioTriggerLevel);

    }else{//hide audio trigger level
        $("#audioLevel").hide();

    }

    $("#SelectModelPreset").val(msg.SoundAdvanceSetting.TimeToTriggerPreset);    
    $("#SelectModelHomeTimes").val(msg.SoundAdvanceSetting.BackToHomeTime);


    $("#SelectModelHomeCamera option").remove();  //remove all option
    for(var i=0; i<msg.SoundAdvanceSetting.BackToHomeCameraArray.length;i++){
        var option = $("<option />");
        option.val(msg.SoundAdvanceSetting.BackToHomeCameraArray[i].Camera).text(msg.SoundAdvanceSetting.BackToHomeCameraArray[i].Model);
        $("#SelectModelHomeCamera").append(option);
    }

    $("#SelectModelHomeCamera").val(msg.SoundAdvanceSetting.BackToHomeSwitchCamera);
    $("#SelectModelHomePosition").val(msg.SoundAdvanceSetting.BackToHomePos);
    $("#InputModelHomePosition").val(msg.SoundAdvanceSetting.BackToHomePreset);

    if(document.getElementById("SelectModelHomePosition").value == 0){
        document.getElementById("InputModelHomePosition").disabled = true;
    }
    else{
        document.getElementById("InputModelHomePosition").disabled = false;
    }

}

function updateSoundNumbers(msg) {

    var tabIndex = 0;

    console.log('msg.SoundNumbers:',msg.SoundNumbers);
    $("#deviceCntSel").val(msg.SoundNumbers); // setting device number
    syncDeviceCount();

    //update all tabs name
    for(tabIndex = (msg.SoundNumbers-1) ; tabIndex >=0; tabIndex--){
        $("#A_tabDevice_"+ tabIndex).trigger("click");   
    }
}

function DisableResolutonAndFps(status) {

    document.getElementById("selectResolution").disabled = status;
    document.getElementById("selectFPS").disabled = status;
}

function updatedSearchCameraTable(msg) {

    var table = document.getElementById("tableSearchCamera");
    if(!table) return;
    var curCameraTableCnt = table.rows.length;
    var index = 0;
    var rowlast;
    var celllast;

    console.log('msg.cameraCnt:',msg.CameraCount);
    console.log('curCameraTableCnt:',curCameraTableCnt);

    //delete all table content
    if(curCameraTableCnt > 1){
        for(index=curCameraTableCnt;index > 1 ;index--){
            table.deleteRow(index-1);
        }
    }

    gCameraConnCnt = 0;
    //update table content
    for(index=0;index < msg.CameraCount; index++){

        //var newWindow = window.open(msg.CamerasArray[index].IPAddress, "Test", "width=335,height=330,resizable=1,toolbar=1,scrollbars=1,status=0")

        rowlast = table.insertRow(); //add row


        celllast = rowlast.insertCell();//add colum
        celllast.innerHTML="<label id =\"cameraName_"+index+"\" class=\"Font_Arial_14 userFiledTitle\" disabled></label>";
        celllast = rowlast.insertCell();
        celllast.innerHTML="<label id =\"cameraIP_"+index+"\" class=\"Font_Arial_14 userFiledTitle \"></label>";
        celllast = rowlast.insertCell();
        celllast.innerHTML = "<label id =\"cameraStatus_" + index + "\" class=\"Font_Arial_14 cameraFiledTitle\"></label>";
        celllast = rowlast.insertCell();
        celllast.innerHTML = "<label id =\"cameraPTZ_" + index + "\" class=\"Font_Arial_14 cameraFiledTitle\">PTZ Control</label>";
        celllast = rowlast.insertCell();
        celllast.innerHTML = "<label id =\"cameraAISetting_" + index + "\" class=\"Font_Arial_14 cameraFiledTitle\">AI Setting</label>";

        //update camera information
        document.getElementById("cameraName_"+index).innerText = msg.CamerasArray[index].ModelName;
        document.getElementById("cameraIP_"+index).innerText = msg.CamerasArray[index].IPAddress;

        if(msg.CamerasArray[index].IsConnect == "0"){
            document.getElementById("cameraStatus_"+index).innerText = "Connect";
            document.getElementById("cameraStatus_"+index).style.backgroundColor = "#000000";//black
        }
        else{
            document.getElementById("cameraStatus_"+index).innerText = "Disonnect";
            document.getElementById("cameraStatus_"+index).style.backgroundColor = "#ffffff";//white
            gCameraConnCnt++;
        }
    }

    //Disable Resolution&FPS, if it has any camera status is connected
    if(gCameraConnCnt > 0)
        DisableResolutonAndFps(true);

    $(".mytable td").click(function(){
        var tdSeq = $(this).parent().find("td").index($(this)[0]);
        var trSeq = $(this).parent().parent().find("tr").index($(this).parent()[0]);

        gTableRowIndex = trSeq;
        //alert( (tdSeq + 1) + "col，" + (trSeq + 1) + "row");

        if(trSeq > 0 ){

            if(tdSeq == 2 ){ //camera connect
                CameraConnClick(trSeq);
            }else if(tdSeq == 3 ){ //PTZControl
                PTZControl();
            }else if(tdSeq == 4 ){ //AI setting
                AISettingClick(trSeq);
            }
        }
    });

}

function CameraConnClick(rowIndex){

    var index  = rowIndex;
    var ip     = document.getElementById("cameraIP_"+(index-1)).innerText;
    var status = document.getElementById("cameraStatus_"+(index-1)).innerText;


    if(status == "Connect") 
    {
        if(gCameraConnCnt<4)//max camera count is "4"
        {
            sendMessage("CameraConnect",ip);
            blockUIforPage();
        }
    }
    else
    {
        sendMessage("CameraDisconnect",ip);
        document.getElementById("cameraStatus_"+(index-1)).innerText = "Connect";
        document.getElementById("cameraStatus_"+(index-1)).style.backgroundColor = "#000000";//black
        gCameraConnCnt--;

        if(gCameraConnCnt > 0)
            DisableResolutonAndFps(true);
        else
            DisableResolutonAndFps(false);
        sendMessage("GetSoundCamMap" ,gDeviceIndex);
    }
} 

function AISettingClick(rowIndex){

    var index = rowIndex;
    var ip = document.getElementById("cameraIP_"+(index-1)).innerText;

    if(document.getElementById("cameraStatus_"+(index-1)).innerText == "Disonnect")
    {
        sendMessage("GetCamAISetting",ip); // get AI Setting infor
    }
}

function GetPTZInfo(CameraIP) {

    var jsonmsg = {};

    jsonmsg.Command = "GetFocusMode";
    jsonmsg.IPAddress = CameraIP;
    sendMessage("GetFocusMode",jsonmsg);

    jsonmsg.Command = "GetMirrorFlipType";
    jsonmsg.IPAddress = CameraIP;
    sendMessage("GetMirrorFlipType",jsonmsg);

    jsonmsg.Command = "GetPanFlip";
    jsonmsg.IPAddress = CameraIP;
    sendMessage("GetPanFlip",jsonmsg);
}

function PTZControl(){


    var url = 'http://'+ document.getElementById("cameraIP_"+(gTableRowIndex-1)).innerText;

    var cameraIP = document.getElementById("cameraIP_"+(gTableRowIndex-1)).innerText;

    var ch = '.';
    var count = cameraIP.split(ch).length - 1;
    console.log(count);

    if(document.getElementById("cameraStatus_"+(gTableRowIndex-1)).innerText == "Disonnect")
    {    
        if(count == 3){//ip camera
            window.open(url);
        }
        else{// USB camera

            if (gPTZTimerId != null) {
                clearInterval(gPTZTimerId);
                gPTZTimerId = null;
            }

            $('#PTZModal').modal('show');
            gPTZTimerId = setInterval("imgSrcChange()", 1000);
            GetPTZInfo(cameraIP);
        }
    }

}

function imgSrcChange() {

    dmsimg = document.getElementById("imgloader");
 
    var imgsrc = dmsimg.src;
    var result = imgsrc.indexOf("_A");


    if(result == -1)
        dmsimg.src ="http://"+location.hostname+"/dms_video0_A.jpg";
    else
        dmsimg.src ="http://"+location.hostname+"/dms_video0_B.jpg";

}

function sendMessage(cmd,data) {

    var msg = cmd;


    if ( websocket != null )
    {
        //document.getElementById("inputText").value = "";
        //websocket.send( msg );
        var jsonmsg = {};

        jsonmsg.Command = msg;

        if(msg == "AddCamera"){
            jsonmsg.IPAddress = data; //AddCamera
        }     
        else if(msg == "GetSoundAdvanceSetting"){
            jsonmsg.SoundTabIndex = data;
        } 
        else if(msg == "GetSoundSetting"){
            jsonmsg.SoundTabIndex = data;
        } 
        else if(msg == "GetSoundCamMap"){
            jsonmsg.SoundTabIndex = data;
        }
        else if(msg == "GetCamAISetting"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "SetSoundNumbers"){
            jsonmsg.SoundNumbers = data;
        }
        else if(msg == "SetSoundAdvanceSetting" || msg == "SetSoundSetting"){
            jsonmsg = data;
        }
        else if(msg == "SoundConnect" || msg == "SoundDisconnect"){
            jsonmsg.SoundTabIndex = data;
        }
        else if(msg == "SetSoundCamMap"){
            jsonmsg = data;
        }
        else if(msg == "SetCamAISetting"){
            jsonmsg = data;
        }
        else if(msg == "CameraConnect"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "CameraDisconnect"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "SetVideoResolution"){
            jsonmsg.VideoResolution = data;
        }
        else if(msg == "SetVideoFps"){
            jsonmsg.VideoFps = data;
        }
        else if(msg == "SetSettingMode"){
            jsonmsg.Status = data;
        }
        else if(msg == "GetSoundDevicePort"){
            jsonmsg = data;
        }
        else if(msg == "GetFocusMode" || msg == "GetMirrorFlipType" || msg == "GetPanFlip"){
            jsonmsg = data;
        }
        else if(msg == "SetPanTiltStart" || msg == "SetPanTiltStop" || msg == "SetPanTiltHome"){
            jsonmsg = data;
        }
        else if(msg == "SetFocusStop" || msg == "SetFocusStart"){
            jsonmsg = data;
        }
        else if(msg == "SetZoomStop" || msg == "SetZoomStart"){
            jsonmsg = data;
        }
        else if(msg == "SetMirrorFlip" || msg == "SetPanFlip" || msg == "SetFocusMode"){
            jsonmsg = data;
        }
        else if(msg == "SetToCallPreset" || msg == "SetToSavePreset"){
            jsonmsg = data;
        }

        //var jsonmsg = {
        //   Command : msg
            //ws_msg : msg//"49.138077,-122.857472"
        //};
        websocket.send( JSON.stringify(jsonmsg) );
        //console.log( "string sent :", JSON.stringify(jsonmsg) );
    }
}

function onSearchCamera() {

    sendMessage("SearchCamera");
}

function onAddCamera() {

    var data = document.getElementById("CameraIPInput").value ;//get camera IP

    sendMessage("AddCamera",data);
}

function initAdvancedContent() {

    var index = 0;

    for(index=0; index<16; index++){

        $( "#advancedButton_"+index ).click(function() {
            GetSoundAdvanceInfo();
        });
    }

}

function initCameraMappingContent(){

    var initMaxDivIndex = 5;
    var initMaxCnt      = 8;

    for(var i = 1; i <= initMaxDivIndex;i++){

        if(i==2){
            initMaxCnt =4;
        }else{
            initMaxCnt =8;
        }

        switch(i){

            case 1://Div_1
                for(var j=0;j<initMaxCnt;j++){
                    document.getElementById("cameraMappingSeleceItem_div1_"+j).onchange = function() {onChangeCameraMappingApplyStatus(1)};
                    document.getElementById("cameraMappingPreset_div1_"+j).onchange = function() {onChangeCameraMappingApplyStatus(1)};
                }
                break;

            case 2://Div_2
                for(var j=0;j<initMaxCnt;j++){
                    document.getElementById("cameraMappingSeleceItem_div2_"+j).onchange = function() {onChangeCameraMappingApplyStatus(2)};
                    document.getElementById("cameraMappingPreset_div2_"+j).onchange = function() {onChangeCameraMappingApplyStatus(2)};
                }
                break;

            case 3://Div_3
                for(var j=0;j<initMaxCnt;j++){
                    document.getElementById("cameraMappingSeleceItem_div3_"+j).onchange = function() {onChangeCameraMappingApplyStatus(3)};
                    document.getElementById("cameraMappingPreset_div3_"+j).onchange = function() {onChangeCameraMappingApplyStatus(3)};
                    document.getElementById("cameraMappingAzimuthFrom_div3_"+j).onchange = function() {onChangeCameraMappingApplyStatus(3)};
                    document.getElementById("cameraMappingAzimuthTo_div3_"+j).onchange = function() {onChangeCameraMappingApplyStatus(3)};
                }
            break;

            case 4://Div_4
                for(var j=0;j<initMaxCnt;j++){
                    document.getElementById("cameraMappingSeleceItem_div4_"+j).onchange = function() {onChangeCameraMappingApplyStatus(4)};
                    document.getElementById("cameraMappingPreset_div4_"+j).onchange = function() {onChangeCameraMappingApplyStatus(4)};
                    document.getElementById("cameraMappingAzimuthFrom_div4_"+j).onchange = function() {onChangeCameraMappingApplyStatus(4)};
                    document.getElementById("cameraMappingAzimuthTo_div4_"+j).onchange = function() {onChangeCameraMappingApplyStatus(4)};
                }
            break;

            case 5://Div_5
                for(var j=0;j<initMaxCnt;j++){
                    document.getElementById("cameraMappingSeleceItem_div5_"+j).onchange = function() {onChangeCameraMappingApplyStatus(5)};
                    document.getElementById("cameraMappingPreset_div5_"+j).onchange = function() {onChangeCameraMappingApplyStatus(5)};
                    document.getElementById("cameraMappingAzimuthFrom_div5_"+j).onchange = function() {onChangeCameraMappingApplyStatus(5)};
                    document.getElementById("cameraMappingAzimuthTo_div5_"+j).onchange = function() {onChangeCameraMappingApplyStatus(5)};
                }
            break;

        }
    }
}

function sendStorePresetCmd(strSet) {

    var jsonmsg = {};
    var cameraIP = document.getElementById("cameraIP_"+(gTableRowIndex-1)).innerText;

    jsonmsg.Command   = "SetToSavePreset";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Preset    = parseInt(strSet,10);
    sendMessage("SetToSavePreset",jsonmsg);

}

function sendRecallPresetCmd(strSet) {

    var jsonmsg = {};
    var cameraIP = document.getElementById("cameraIP_"+(gTableRowIndex-1)).innerText;

    jsonmsg.Command   = "SetToCallPreset";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Preset    = parseInt(strSet,10);
    sendMessage("SetToCallPreset",jsonmsg);

}

function presetTextAction(strSet) {
    var strVal = $("#presetInput").val();
    switch (strVal.length) {
        case 0:
            strVal = strVal.concat(strSet);
            break;
        case 1:
            if (strVal == "0") {
                strVal = strSet;
            } else {
                strVal = strVal.concat(strSet);
            }
            break;
        case 2:
            if (strSet < "6") {
                if (strVal <= "25") {
                    strVal = strVal.concat(strSet);
                }
                //else do nothing
            } else {
                if (strVal <= "24") {
                    strVal = strVal.concat(strSet);
                }
            }
            break;
        case 3:
            //do nothing
            break;
        case 4:
            strVal = "";
            break;
    }
    $("#presetInput").val(strVal);
}

function PTZMirrorFlipTypeChange(){

    var jsonmsg = {};
    var value = document.getElementById("PTZMirrorFlipType").value;
    var cameraIP = document.getElementById("cameraIP_"+(gTableRowIndex-1)).innerText;

    jsonmsg.Command   = "SetMirrorFlip";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Type      = parseInt(value,10);
    sendMessage("SetMirrorFlip",jsonmsg);

}

function focusModeChange(e){

    var jsonmsg  = {};
    var cameraIP = document.getElementById("cameraIP_"+(gTableRowIndex-1)).innerText;
    var focusMode;

    if(e.checked == false){
        focusMode = "Manual";
    }else{
        focusMode = "Auto";
    }

    jsonmsg.Command   = "SetFocusMode";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Mode      = focusMode;
    sendMessage("SetFocusMode",jsonmsg);

}

var ptCmdRun = false;
var focusCmdRun = false;
var zoomCmdRun = false;

// PanTilt control
function sendPanTiltCmd(dir) {

    var ptzcmd;
    var jsonmsg = {};
    var cameraIP = document.getElementById("cameraIP_"+(gTableRowIndex-1)).innerText;

    if (dir == 'stop') {
        ptzcmd = "SetPanTiltStop";
    } else if(dir == 'home') {
        ptzcmd = "SetPanTiltHome";
    } else {
        ptzcmd = "SetPanTiltStart";
        jsonmsg.Direction = dir;
    }

    jsonmsg.Command   = ptzcmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessage(ptzcmd,jsonmsg);
}



function stopPanTiltMoving() {
    if (ptCmdRun == false)
        return;
    ptCmdRun = false;
    clearTimeout($(this).data('timer'));
    dir = 'stop';
    setTimeout(function () {
        sendPanTiltCmd(dir);
    }, 500);
}

/*function PanTiltElement() {

    var dir;
    $('#ptDownLeftButton').on({
        mousedown: function (e) {
            dir = 'LeftDown';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#ptDownButton').on({
        mousedown: function (e) {
            dir = 'Down';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#ptDownRightButton').on({
        mousedown: function (e) {
            dir = 'RightDown';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#ptLeftButton').on({
        mousedown: function (e) {
            dir = 'Left';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });

    $('#HomeButton').on({
        mousedown: function (e) {
            dir = 'home';
            sendPanTiltCmd(dir);
        }
    });

    $('#ptRightButton').on({
        mousedown: function (e) {
            dir = 'Right';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#ptUpLeftButton').on({
        mousedown: function (e) {
            dir = 'LeftUp';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#ptUpButton').on({
        mousedown: function (e) {
            dir = 'Up';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#ptUpRightButton').on({
        mousedown: function (e) {
            dir = 'RightUp';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
}*/

//Focus control
function sendManualFocusCmd(dir) {

    var focuscmd;
    var jsonmsg = {};
    var cameraIP = document.getElementById("cameraIP_"+(gTableRowIndex-1)).innerText;

    if (dir == 'stop') {
        focuscmd = "SetFocusStop";
    } else {
        focuscmd = "SetFocusStart";
        jsonmsg.Direction = dir;
    }

    jsonmsg.Command   = focuscmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessage(focuscmd,jsonmsg);

}

function stopFocusMoving() {

    if (focusCmdRun == false)
        return;
    focusCmdRun = false;
    clearTimeout($(this).data('timer'));

    setTimeout(function () {
        sendManualFocusCmd('stop');
    }, 500);


}

function ManualFocusControl() {

    $('#focusNearButton').on({
        mousedown: function (e) {
            focusCmdRun = true;
            setTimeout(function () {
                sendManualFocusCmd('Near');
            }, 100);
        },
        mouseup: function () {
            stopFocusMoving();
        },
        mouseleave: function () {
            stopFocusMoving();
        }
    });

    $('#focusFarButton').on({
        mousedown: function (e) {
            focusCmdRun = true;
            setTimeout(function () {
                sendManualFocusCmd('Far');
            }, 100);
        },
        mouseup: function () {
            stopFocusMoving();
        },
        mouseleave: function () {
            stopFocusMoving();
        }
    });
}

//Zoom control
function sendZoomStopCmd() {
    if (zoomCmdRun == false)
        return;
    zoomCmdRun = false;
    clearTimeout($(this).data('timer'));

    setTimeout(function () {
        sendZoomCmd('Stop');
    }, 500);
}

function sendZoomCmd(telewide) {

    var zoomcmd;
    var jsonmsg = {};
    var cameraIP = document.getElementById("cameraIP_"+(gTableRowIndex-1)).innerText;

    if (telewide == 'Stop') {
        zoomcmd = "SetZoomStop";
    } else {
        zoomcmd = "SetZoomStart";
        jsonmsg.Direction = telewide;
    }

    jsonmsg.Command   = zoomcmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessage(zoomcmd,jsonmsg);

}

function ZoomBtnElements() {

    $('#zoomWideButton').on({
        mousedown: function (e) {
            zoomCmdRun = true;
            setTimeout(function () {
                sendZoomCmd('Out');
            }, 100);
        },
        mouseup: function () {
            sendZoomStopCmd();
        },
        mouseleave: function () {
            sendZoomStopCmd();
        }
    });

    $('#zoomTeleButton').on({
        mousedown: function (e) {
            zoomCmdRun = true;
            setTimeout(function () {
                sendZoomCmd('In');
            }, 100);
        },
        mouseup: function () {
            sendZoomStopCmd();
        },
        mouseleave: function () {
            sendZoomStopCmd();
        }
    });
}

function openCameraList() {
    $("#DivMainPage").load("./page/cameralist.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;
        initWebSocket();

        $( "#BtnAISettingModalClose" ).click(function() {//close modal
            $('#AISettingModal').modal('hide');
        });
    });
}


function openStream() {
    $("#DivMainPage").load("./page/stream.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;
        initWebSocket();

        if (cameraSettings.ModelName == "CV420e") {
            $(".tabPageDiv").removeClass("tabPageDiv");
            $(".tabNavDiv").hide();
            $(".tabs-content").removeClass("tabs-content").removeClass("content_H702");
            $("#Div_StreamType").removeClass("tabs-panel").removeClass("panel_H702");
        } else {
            //tabPage();
            //tabPageStream();
        }

        //initWebSocket();

        //syncDeviceCount();

        //syncDeviceType();
        

        initAdvancedContent(); //advanced window init
        

        initCameraMappingContent();


        $( "#BtnModelClose" ).click(function() {//close modal
            document.getElementById("BtnModelApply").disabled = true;
            $('#exampleModal').modal('hide');

        });

        $( "#BtnRightUpClose" ).click(function() {//close modal
            $('#AISettingModal').modal('hide');
        });

        $( "#BtnPTZModalClose" ).click(function() {//close modal

            if (gPTZTimerId != null) {
                clearInterval(gPTZTimerId);
                gPTZTimerId = null;
            }
            $('#PTZModal').modal('hide');  
        });

        PanTiltElement();
        ManualFocusControl();
        ZoomBtnElements();

        //Preset
        $("#presetInput").change(function () {
            filterNumberInRange(this, 0, 255);
        });

        $("#presetRecallButton").on('click', function () {
            //sendSingleCGICmd("presetposition", "PresetCall", $("#presetInput").val());
            sendRecallPresetCmd($("#presetInput").val());
            $("#presetInput").val("");
        });

        $("#presetStoreButton").on('click', function () {
            //sendSingleCGICmd("presetposition", "PresetSet", $("#presetInput").val());
            sendStorePresetCmd($("#presetInput").val());
            $("#presetInput").val("");
        });
    });
}

function tabPageStream(){
    var tabs_menu = document.getElementsByClassName("tabs-menu");
    for (var k = 0; k < tabs_menu.length; k++) {
        tabs_menu[k].onclick = js_tabsStream;
    }
    function js_tabsStream() {
        var tab_id = this.getAttribute("data-target");
        var tabs_panel = document.getElementsByClassName("tabs-panel");
        
        for (var i = 0; i < tabs_panel.length; i++) {
            tabs_panel[i].style.display = "none";
        }
        for (var j = 0; j < tabs_menu.length; j++) {
            tabs_menu[j].className = tabs_menu[j].className.replace(" tabs-menu-active", "");
        }
        this.className += " tabs-menu-active";
        document.getElementById(tab_id).style.display = "block";

        for (var searchIndex = 0; searchIndex < tabs_menu.length; searchIndex++) {
            
            if(tabs_menu[searchIndex].className.indexOf("tabs-menu-active") != -1){
                gDeviceIndex = searchIndex; //current tab focus
                sendMessage("GetSoundSetting",gDeviceIndex);
                sendMessage("GetSoundCamMap" ,gDeviceIndex);
                break;
            }

        }
        
        return false;
    }
};

function GetSoundAdvanceInfo() {

      sendMessage("GetSoundAdvanceSetting",gDeviceIndex);

}


function onShowHidePassword(){

    var passwordType = document.getElementById("PasswordInput_"+gDeviceIndex).type;

    if(passwordType == "password"){
        document.getElementById("PasswordInput_"+gDeviceIndex).type="text";
        document.getElementById("PasswordIcon_"+gDeviceIndex).src="../imagesaibox/Open.png"
    }else{
        document.getElementById("PasswordInput_"+gDeviceIndex).type="password";
        document.getElementById("PasswordIcon_"+gDeviceIndex).src="../imagesaibox/Close.png"
    }
    

}

